/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.SubGuiEditText;
import noppes.npcs.client.gui.select.GuiSoundSelection;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.Lines;
import noppes.npcs.entity.EntityNPCInterface;

public class SubGuiNPCLinesEdit
extends SubGuiInterface
implements ICustomScrollListener,
ISubGuiListener,
ITextfieldListener {
    public Lines lines;
    private final Map<String, Integer> data = new LinkedHashMap<String, Integer>();
    private GuiCustomScroll scroll;
    private String select = "";
    private final String title;

    public SubGuiNPCLinesEdit(int id, EntityNPCInterface npc, Lines lines, String title) {
        super(npc);
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 217;
        this.closeOnEsc = true;
        this.id = id;
        this.lines = lines.copy();
        if (title == null) {
            title = "";
        }
        this.title = title;
        Client.sendData(EnumPacketServer.MainmenuAdvancedGet, new Object[0]);
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (this.select.isEmpty() && this.scroll.hasSelected()) {
            this.select = this.scroll.getSelected();
        }
        switch (button.getID()) {
            case 0: {
                this.setSubGui(new SubGuiEditText(0, CustomNpcs.DefaultInteractLine));
                break;
            }
            case 1: {
                if (!this.data.containsKey(this.select)) {
                    return;
                }
                this.lines.remove(this.data.get(this.select));
                if (this.scroll != null && this.scroll.getSelect() > 0) {
                    this.scroll.setSelect(this.scroll.getSelect() - 1);
                }
                this.func_73866_w_();
                break;
            }
            case 2: {
                if (!this.data.containsKey(this.select) || !this.lines.lines.containsKey(this.data.get(this.select))) {
                    this.setSubGui(new SubGuiEditText(0, CustomNpcs.DefaultInteractLine));
                    return;
                }
                this.setSubGui(new GuiSoundSelection(this.lines.lines.get(this.data.get(this.select)).getSound()));
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.data.clear();
        int p = 0;
        TextComponentTranslation t = new TextComponentTranslation("parameter.position", new Object[0]);
        TextComponentTranslation m = new TextComponentTranslation("parameter.iline.text", new Object[0]);
        TextComponentTranslation s = new TextComponentTranslation("parameter.sound.name", new Object[0]);
        t.func_150256_b().func_150238_a(TextFormatting.GRAY);
        m.func_150256_b().func_150238_a(TextFormatting.GRAY);
        s.func_150256_b().func_150238_a(TextFormatting.GRAY);
        ArrayList<String> suffixes = new ArrayList<String>();
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        for (int i : this.lines.lines.keySet()) {
            Line l = this.lines.lines.get(i);
            this.data.put("\u00a77" + i + ": " + '\u00a7' + "r" + l.getText(), i);
            ArrayList<String> hover = new ArrayList<String>();
            hover.add(t.func_150254_d() + '\u00a7' + "7: " + '\u00a7' + "f" + i);
            hover.add(m.func_150254_d() + '\u00a7' + "7:");
            hover.add(l.getText());
            if (!l.getSound().isEmpty()) {
                hover.add(s.func_150254_d() + '\u00a7' + "7:");
                hover.add(l.getSound());
                suffixes.add("\u00a77[\u00a7eS\u00a77]");
            } else {
                suffixes.add("");
            }
            hts.put(p, hover);
        }
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(this.xSize - 12, this.ySize - 63);
        }
        ArrayList<String> list = new ArrayList<String>(this.data.keySet());
        this.scroll.setListNotSorted(list);
        this.scroll.guiLeft = this.guiLeft + 6;
        this.scroll.guiTop = this.guiTop + 14;
        Line line = null;
        if (!this.select.isEmpty()) {
            if (list.contains(this.select)) {
                line = this.lines.lines.get(this.data.get(this.select));
                this.scroll.setSelected(this.select);
            } else {
                this.select = "";
            }
        }
        this.scroll.setSuffixes(suffixes);
        this.scroll.setHoverTexts(hts);
        this.addScroll(this.scroll);
        this.addLabel(new GuiNpcLabel(1, this.title.isEmpty() ? "" : this.title, this.guiLeft, this.guiTop + 4));
        this.getLabel(1).setCenter(this.xSize);
        int x = this.guiLeft + 6;
        int y = this.guiTop + 170;
        GuiNpcTextField textField = new GuiNpcTextField(0, this, x, y, this.xSize - 86, 20, line == null ? "" : line.getText());
        textField.setHoverText("lines.hover.text", new Object[0]);
        this.addTextField(textField);
        GuiNpcButton button = new GuiNpcButton(0, this.guiLeft + this.xSize - 77, y, 50, 20, "gui.add");
        button.setHoverText("lines.hover.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(1, this.guiLeft + this.xSize - 25, y, 20, 20, "X");
        button.setHoverText("lines.hover.remove", new Object[0]);
        this.addButton(button);
        textField = new GuiNpcTextField(1, this, x + 52, y += 22, this.xSize - 116, 20, line == null ? "" : line.getSound());
        textField.setHoverText("lines.hover.sound", new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcButton(2, this.guiLeft + this.xSize - 55, y, 50, 20, "availability.select");
        button.setHoverText("bard.hover.select", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(66, x, y, 50, 20, "gui.done");
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (!this.data.containsKey(scroll.getSelected())) {
            return;
        }
        this.select = scroll.getSelected();
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui instanceof SubGuiEditText) {
            SubGuiEditText sub = (SubGuiEditText)subgui;
            if (sub.cancelled || sub.text[0].isEmpty()) {
                return;
            }
            Line line = new Line(sub.text[0]);
            this.lines.correctLines();
            int p = this.lines.lines.size();
            this.lines.lines.put(p, line);
            this.select = "\u00a77" + p + ": " + '\u00a7' + "r" + line.getText();
            this.func_73866_w_();
        } else if (subgui instanceof GuiSoundSelection) {
            if (!this.data.containsKey(this.select)) {
                return;
            }
            GuiSoundSelection sub = (GuiSoundSelection)subgui;
            if (sub.selectedResource == null) {
                return;
            }
            if (!this.data.containsKey(this.select) || !this.lines.lines.containsKey(this.data.get(this.select))) {
                return;
            }
            this.lines.lines.get(this.data.get(this.select)).setSound(sub.selectedResource.toString());
            this.func_73866_w_();
        }
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (this.hasSubGui()) {
            return;
        }
        if (textField.getID() == 0) {
            if (!this.data.containsKey(this.select) || !this.lines.lines.containsKey(this.data.get(this.select))) {
                return;
            }
            this.lines.lines.get(this.data.get(this.select)).setText(textField.getFullText());
            this.select = textField.getFullText();
            this.func_73866_w_();
        }
    }
}

